#!/bin/bash

# Prompt the user for their GitHub username
read -p "Enter your GitHub username: " USERNAME

# Get the GitHub public key URL
KEY_URL="https://github.com/$USERNAME.keys"

# Download the public key
wget -q -O - "$KEY_URL" > ~/.ssh/authorized_keys

# Set appropriate permissions for the authorized_keys file
chmod 600 ~/.ssh/authorized_keys

# Check if the .ssh directory exists and create it if it doesn't
if [ ! -d ~/.ssh ]; then
  mkdir -p ~/.ssh
  chmod 700 ~/.ssh
fi

echo "Public key successfully added to authorized_keys"