#!/bin/bash

USERNAME="yaisme"
PUBKEY="ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIBbRbeHr4ikRGKRKYUpO1Dvn408aXrtsdVrtgasNQZkq yaisme-ed25519"
SUDOERS_LINE="$USERNAME  ALL=(ALL) NOPASSWD:ALL"

# Prompt for password
read -s -p "Enter password for user '$USERNAME': " PASSWORD
echo

# 1. Check if the user exists
if id "$USERNAME" &>/dev/null; then
    echo "User '$USERNAME' already exists."
else
    echo "Creating user '$USERNAME'..."
    useradd -m -s /bin/bash "$USERNAME"
    echo "$USERNAME:$PASSWORD" | chpasswd
fi

# 1.2 Add SSH public key
SSH_DIR="/home/$USERNAME/.ssh"
AUTHORIZED_KEYS="$SSH_DIR/authorized_keys"

mkdir -p "$SSH_DIR"
echo "$PUBKEY" > "$AUTHORIZED_KEYS"
chown -R "$USERNAME:$USERNAME" "$SSH_DIR"
chmod 700 "$SSH_DIR"
chmod 600 "$AUTHORIZED_KEYS"
echo "SSH key added for user '$USERNAME'."

# 2. Check and update sudoers
SUDOERS_FILE="/etc/sudoers"
if sudo grep -q "^$USERNAME " "$SUDOERS_FILE"; then
    # Replace existing line
    echo "Updating sudoers entry for '$USERNAME'..."
    sudo sed -i.bak "/^$USERNAME /c\\$SUDOERS_LINE" "$SUDOERS_FILE"
else
    # Append new line
    echo "Adding sudoers entry for '$USERNAME'..."
    echo "$SUDOERS_LINE" | sudo tee -a "$SUDOERS_FILE" > /dev/null
fi

echo "Done."
