#!/bin/bash

echo -e "SIZE\tPOD_NAME\tNAMESPACE\tCONTAINER_NAME\tLOG_PATH"

# Step 1: Find all container logs and sort by size
sudo find /var/lib/docker/containers/ -type f -name "*.log" | while read -r logfile; do
#  echo -e "$logfile"
  # Get file size
  size=$(sudo du -h "$logfile" | awk '{print $1}')
  #echo -e "$size\t$logfile"
  # Get container ID from filename or path
  container_id=$(basename "$logfile" | cut -d'-' -f1)
  #echo -e "$size\t$container_id"

  # Use docker inspect to get Kubernetes labels
  #pod_name=$(docker inspect "$container_id" 2>/dev/null | grep '"io.kubernetes.pod.name"' | cut -d':' -f2 | tr -d ' ",')
  #namespace=$(docker inspect "$container_id" 2>/dev/null | grep '"io.kubernetes.pod.namespace"' | cut -d':' -f2 | tr -d ' ",')
  container_name=$(docker inspect "$container_id" 2>/dev/null | grep '"io.kubernetes.container.name"' | cut -d':' -f2 | tr -d ' ",')
  
  # Print results
  #echo -e "$size\t$pod_name\t$namespace\t$container_name\t$logfile"
  echo -e "$size\t$container_name"
done | sort -h
