#!/usr/bin/env bash
# Trim all Docker/K8S container logs to last 1000 lines

KEEP=1000

# Look for all docker json logs
for f in /var/lib/docker/containers/*/*-json.log; do
  if [ -f "$f" ]; then
    echo "Trimming $f ..."
    tmp=$(mktemp)
    tail -n $KEEP "$f" > "$tmp" && cat "$tmp" > "$f"
    rm -f "$tmp"
  fi
done

# Also check kubelet-managed logs (optional)
for f in /var/log/containers/*.log /var/log/pods/*/*/*.log; do
  if [ -f "$f" ]; then
    echo "Trimming $f ..."
    tmp=$(mktemp)
    tail -n $KEEP "$f" > "$tmp" && cat "$tmp" > "$f"
    rm -f "$tmp"
  fi
done

echo "Done."
