#!/bin/bash

TMPFILE=$(mktemp)

# Get all deleted Docker logs that are still open
sudo lsof +L1 | awk '
NR == 1 { next }
$NF ~ /\(deleted\)$/ && $0 ~ /\/var\/lib\/docker\/containers\/.*-json\.log/ { print }
' | while read -r line; do
    PROCESS=$(echo "$line" | awk '{print $1}')
    SIZE=$(echo "$line" | awk '{print $(NF-4)}')
    FILE=$(echo "$line" | awk '{for (i=9; i<=NF; i++) printf $i " "; print ""}' | sed 's/ (deleted)//')

    # Skip if SIZE is not numeric
    if ! [[ "$SIZE" =~ ^[0-9]+$ ]]; then
        continue
    fi

    SIZE_MB=$(awk -v s="$SIZE" 'BEGIN {printf "%.2f", s/1048576}')
    CONTAINER_ID=$(basename "$(dirname "$FILE")")

    # Get container metadata
    INFO=$(docker ps -a --no-trunc --filter "id=$CONTAINER_ID" --format "{{.ID}}|{{.Image}}|{{.Command}}|{{.RunningFor}}|{{.Names}}")
    if [[ -z "$INFO" ]]; then
        ID_SHORT="N/A"; IMAGE="N/A"; CMD="N/A"; CREATED="N/A"; NAMES="N/A"
    else
        IFS='|' read -r ID IMAGE_RAW CMD CREATED NAMES <<< "$INFO"
        ID_SHORT=$(echo "$ID" | cut -c1-12)
        IMAGE=$(echo "$IMAGE_RAW" | sed 's|.*/||' | cut -d':' -f1)
    fi

    echo -e "$SIZE_MB MB\t$PROCESS\t$ID_SHORT\t$CREATED\t$NAMES" >> "$TMPFILE"
done

# Output
#echo -e "Proc\tImage\tSize\tContainer ID\tImage\tCommand\tCreated\tNames"
sort -nk1 "$TMPFILE"

rm -f "$TMPFILE"