#!/bin/bash

# Define version
VERSION="1.9.1"

# Create user for node_exporter
useradd --no-create-home --shell /usr/sbin/nologin node_exporter

# Download and extract Node Exporter
cd /tmp
wget https://github.com/prometheus/node_exporter/releases/download/v$VERSION/node_exporter-$VERSION.linux-amd64.tar.gz
tar xvf node_exporter-$VERSION.linux-amd64.tar.gz

# Move binary to /usr/local/bin
cp node_exporter-$VERSION.linux-amd64/node_exporter /usr/local/bin/
chown node_exporter:node_exporter /usr/local/bin/node_exporter

# Clean up
rm -rf node_exporter-$VERSION.linux-amd64*

# Create systemd service file
cat <<EOF >/etc/systemd/system/node_exporter.service
[Unit]
Description=Prometheus Node Exporter
Wants=network-online.target
After=network-online.target

[Service]
User=node_exporter
Group=node_exporter
Type=simple
ExecStart=/usr/local/bin/node_exporter

[Install]
WantedBy=default.target
EOF

# Reload systemd, enable and start service
systemctl daemon-reexec
systemctl daemon-reload
systemctl enable --now node_exporter

# Check status
systemctl status node_exporter --no-pager

echo "Node Exporter installation complete."
echo "Access it via http://<server-ip>:9100/metrics"
